/***************************************************************************

   Source file Control_system_2020_dsrtvdf.c:

   Definition of function that initializes the global TRC pointers

   4.5 (02-May-2021)
   Thu Nov 21 16:55:54 2024

   Copyright 2024, dSPACE GmbH. All rights reserved.

 *****************************************************************************/

/* Include header file. */
#include "Control_system_2020_dsrtvdf.h"
#include "Control_system_2020.h"
#include "Control_system_2020_private.h"

/* Compiler options to turn off optimization. */
#if !defined(DS_OPTIMIZE_INIT_TRC_POINTERS)
#ifdef _MCCPPC

#pragma options -nOt -nOr -nOi -nOx

#endif

#ifdef __GNUC__

#pragma GCC optimize ("O0")

#endif

#ifdef _MSC_VER

#pragma optimize ("", off)

#endif
#endif

/* Definition of Global pointers to data type transitions (for TRC-file access) */
volatile real_T *p_0_Control_system_2020_real_T_0 = NULL;
volatile uint8_T *p_0_Control_system_2020_uint8_T_1 = NULL;
volatile boolean_T *p_0_Control_system_2020_boolean_T_2 = NULL;
volatile real_T *p_1_Control_system_2020_real_T_0 = NULL;
volatile uint16_T *p_1_Control_system_2020_uint16_T_1 = NULL;
volatile boolean_T *p_1_Control_system_2020_boolean_T_2 = NULL;
volatile real_T *p_2_Control_system_2020_real_T_0 = NULL;
volatile uint32_T *p_2_Control_system_2020_uint32_T_2 = NULL;
volatile int_T *p_2_Control_system_2020_int_T_3 = NULL;
volatile boolean_T *p_2_Control_system_2020_boolean_T_4 = NULL;
volatile real_T *p_3_Control_system_2020_real_T_0 = NULL;

/*
 *  Declare the functions, that initially assign TRC pointers
 */
static void rti_init_trc_pointers_0(void);

/* Global pointers to data type transitions are separated in different functions to avoid overloading */
static void rti_init_trc_pointers_0(void)
{
  p_0_Control_system_2020_real_T_0 = &Control_system_2020_B.last_x;
  p_0_Control_system_2020_uint8_T_1 = &Control_system_2020_B.Sum_l;
  p_0_Control_system_2020_boolean_T_2 = &Control_system_2020_B.Memory[0];
  p_1_Control_system_2020_real_T_0 = &Control_system_2020_P.Joule_incr_factor;
  p_1_Control_system_2020_uint16_T_1 =
    &Control_system_2020_P.MatrixDimensionCheck_P1[0];
  p_1_Control_system_2020_boolean_T_2 =
    &Control_system_2020_P.Memory_InitialCondition[0];
  p_2_Control_system_2020_real_T_0 = &Control_system_2020_DW.last_mv_DSTATE;
  p_2_Control_system_2020_uint32_T_2 = &Control_system_2020_DW.m_bpIndex;
  p_2_Control_system_2020_int_T_3 =
    &Control_system_2020_DW.FromWorkspace1_IWORK.PrevIndex;
  p_2_Control_system_2020_boolean_T_4 =
    &Control_system_2020_DW.Memory_PreviousInput[0];
  p_3_Control_system_2020_real_T_0 = &Control_system_2020_X.TransferFcn3_CSTATE;
}

void Control_system_2020_rti_init_trc_pointers(void)
{
  rti_init_trc_pointers_0();
}
